/*
 * Copyright (C) 2020 Intel Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __IA_CSS_ISA_PARAMETER_DEFS_DEP_H
#define __IA_CSS_ISA_PARAMETER_DEFS_DEP_H

#include "ia_css_ff_awb_statistics_param_defs.h"

/*
 * TODO: Adapt this file for IPU6!
 */

/* ==================== DPC_V2 specific properties ==================== */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_DPC_V2			(1)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_DPC_V2			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_DPC_V2			(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_DPC_V2			(1)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_DPC_V2			(1)

/* ==================== PDAF specific properties ==================== */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PAF			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PAF				(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PAF			(1)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PAF				(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PAF				(0)

/* ==================== DPC_PEXT specific properties ==================== */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_DPC_PEXT			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_DPC_PEXT			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_DPC_PEXT			(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_DPC_PEXT			(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_DPC_PEXT			(0)

/* ==================== SIS specific properties ==================== */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_SIS_WB_SIS			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_SIS_WB_SIS			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_SIS_WB_SIS			(0)
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_SIS_SIS			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_SIS_SIS			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_SIS_SIS			(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_SIS_WB_SIS			(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_SIS_SIS			(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_SIS_WB_SIS			(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_SIS_SIS			(0)

/* ==================== STREAM_CROP specific properties ==================== */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_STREAM_CROP		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_STREAM_CROP			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_STREAM_CROP		(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_STREAM_CROP			(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_STREAM_CROP			(0)

/* ========== PIFCONV_A_INPUT specific properties ================= */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PIFCONV_A_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PIFCONV_A_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PIFCONV_A_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PIFCONV_A_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PIFCONV_A_INPUT		(0)

/* ========== PIFCONV_B_INPUT specific properties ================= */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PIFCONV_B_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PIFCONV_B_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PIFCONV_B_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PIFCONV_B_INPUT		(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PIFCONV_B_INPUT		(0)

/* ========== PIFCONV_OUTPUT_NONSCALED specific properties ================= */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PIFCONV_OUTPUT_NONSCALED		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PIFCONV_OUTPUT_NONSCALED		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PIFCONV_OUTPUT_NONSCALED		(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PIFCONV_OUTPUT_NONSCALED		(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PIFCONV_OUTPUT_NONSCALED		(0)

/* ========== PIFCONV_OUTPUT_SCALED specific properties ================= */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PIFCONV_OUTPUT_SCALED		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PIFCONV_OUTPUT_SCALED		(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PIFCONV_OUTPUT_SCALED		(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PIFCONV_OUTPUT_SCALED		(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PIFCONV_OUTPUT_SCALED		(0)

/* ========== PIFCONV_OUTPUT_SIS specific properties ================= */
#define IA_CSS_ISA_KERNEL_IS_PRIMARY_PIFCONV_OUTPUT_SIS			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_IN_PIFCONV_OUTPUT_SIS			(0)
#define IA_CSS_ISA_NEEDS_SPATIAL_OUT_PIFCONV_OUTPUT_SIS			(0)
#define IA_CSS_ISA_NEEDS_SLICED_IN_PIFCONV_OUTPUT_SIS			(0)
#define IA_CSS_ISA_NEEDS_SLICED_OUT_PIFCONV_OUTPUT_SIS			(0)

/* ==================== IDS specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_SECTION_COUNT						(5)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_0					(0x0C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_0					(0x00)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_1					(0x10)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_1					(0x14)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_2					(0x18)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_2					(0x50)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_3					(0x20C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_3					(0x68)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_4					(0x24)
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_4					(0x274)

#define IA_CSS_ISA_PROGRAM_TERMINAL_IDS_V3_1_SECTION_COUNT						(1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_0						(0x08)
#define IA_CSS_ISA_PROGRAM_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_0					(0x0C)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_IDS_V3_1_SECTION_COUNT					(0)

/* Spatial Parameter Terminal In does not exist for IDS */

/* Spatial Parameter Terminal Out does not exist for IDS */

/* Sliced Parameter Terminal In does not exist for IDS */

/* Sliced Parameter Terminal Out does not exist for IDS */

/* ==================== IDS specs - END ==================== */

/* ==================== DPC specs used in PSYS - START ==================== */
/* in addition to register bank, it has a 0x3000 memory bank to store LUT, found in reg_descr.hsd */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_SECTION_COUNT						(5)
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_0					(0x4)		/* GDC Control */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_0					(0x3378)	/* GDC/DPC Control */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_1					(0x1C0)		/* CfgTable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_1					(0x3000)	/* CfgTable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_2					(0x40)		/* HDR factors */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_2					(0x3488)	/* HDR factors */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_3					(0x4)		/* AF Grid Enable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_3					(0x34C8)	/* AF Grid Enable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_4					(0x8)		/* AF Statistics pixels */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_4					(0x34D4)	/* AF Statistics pixels */

#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_SECTION_COUNT						(4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_MAX_SIZE_SECTION_0					(0x4)		/* GDC Control */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_0					(0x3378)	/* GDC/DPC Control */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_MAX_SIZE_SECTION_1					(0x1C0)		/* CfgTable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_1					(0x3000)	/* CfgTable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_MAX_SIZE_SECTION_2					(0x40)		/* HDR factors */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_2					(0x3488)	/* HDR factors */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_MAX_SIZE_SECTION_3					(0x4)		/* AF Grid Enable */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_3					(0x34C8)	/* AF Grid Enable */

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_DPC_V2_SECTION_COUNT					(0)

/* Spatial Parameter Terminal In does not exist for DPC */

/* Spatial Parameter Terminal Out does not exist for DPC */

#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_SECTION_COUNT					(2)
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_MAX_SLICE_SIZE_SECTION_0			(0x4)		/* DPC static LUT limit */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_0			(0x3380)	/* DPC static LUT limit */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_NEXT_SLICE_OFFSET_SECTION_0			(0x4)		/* DPC static LUT limit */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_MAX_SLICE_SIZE_SECTION_1			(0x1000)	/* DPC static LUT */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_1			(0x0)		/* DPC static LUT */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_NEXT_SLICE_OFFSET_SECTION_1			(0x1000)	/* DPC static LUT */

#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_SECTION_COUNT					(2)
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_MAX_SLICE_SIZE_SECTION_0			(0x4)		/* AF LUT limit */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_0			(0x34CC)	/* AF LUT limit */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_NEXT_SLICE_OFFSET_SECTION_0			(0x4)		/* AF LUT limit */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_MAX_SLICE_SIZE_SECTION_1			(0x800)		/* AF Pixels metadata */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_1			(0x2000)	/* AF Pixels metadata */
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_NEXT_SLICE_OFFSET_SECTION_1			(0x800)		/* AF Pixels metadata */

#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_SECTION_COUNT						(3)
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_MAX_SIZE_SECTION_0						(0x4)
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_0					(0x337C) /* DPC Control */
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_MAX_SIZE_SECTION_1						(0x1B8)		/* CfgUnitMapping */
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_1					(0x31C0)	/* CfgUnitMapping */
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_MAX_SIZE_SECTION_2						(0x100)		/* AF pixels grid cfg */
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_2					(0x3388)	/* AF pixels grid cfg */

/* ==================== DPC specs - END ==================== */

/* ==================== DPC_PEXT specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_PEXT_SECTION_COUNT						(2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_PEXT_MAX_SIZE_SECTION_0					(0x8)
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_PEXT_DEST_OFFSET_SECTION_0					(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_PEXT_MAX_SIZE_SECTION_1					(0x8)
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_PEXT_DEST_OFFSET_SECTION_1					(0xC)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_DPC_PEXT_SECTION_COUNT					(0)
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_PEXT_SECTION_COUNT						(0)
/* ==================== DPC_PEXT specs - END ==================== */

/* TODO check ae values */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_AE_COMPUTE_UNITS_PER_ELEM (1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_AE_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH (16)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_AE_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT (80)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_AE_ELEM_SIZE_SECTION_0 (0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_AE_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH (16)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_AE_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT (80)

/* todo check gddpc_pext values when enabling this terminal */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_GDDPC_PEXT_COMPUTE_UNITS_PER_ELEM (8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_GDDPC_PEXT_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH (8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_GDDPC_PEXT_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT (8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_GDDPC_PEXT_ELEM_SIZE_SECTION_0 (0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_GDDPC_PEXT_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH (64)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_GDDPC_PEXT_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT (64)

/* ==================== PAF specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PAF_SECTION_COUNT							(2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PAF_MAX_SIZE_SECTION_0						(0x18)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PAF_DEST_OFFSET_SECTION_0						(0x0)

/* This is an PAF ACB configuration an not really the configuration on PAF FF. Hence giving - offsets*/
#define IA_CSS_ISA_PARAMETER_TERMINAL_PAF_MAX_SIZE_SECTION_1						(0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PAF_DEST_OFFSET_SECTION_1						(-0xB0)

#define	IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PAF_SECTION_COUNT						(0)
/* Number of PAF blocks = 12*16 PAF blocks
 * Max number of phase steps in each block: 11 steps (0-10)
 * 	for step 10, only the LSB values are valid and MSB 2bytes are reserved
 * 	Hence for each block height, we will have to read in 12 steps
 * Size of each phase value =  2 bytes
 * Total size required for PAF output = 2bytes * 12*16 blocks *12 steps
 * */

/* Spatial Parameter Terminal In does not exist for PAF*/

/* Spatial Parameter Terminal Out for PAF*/
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_PAF_SECTION_COUNT					(1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_PAF_COMPUTE_UNITS_PER_ELEM				(1)	/**/

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_PAF_MAX_SLICE_SIZE_SECTION_0				(0x1200) /*12*16 #PAF blocks# * 2bytes*12 #Phase output size per block#*/
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_PAF_ELEM_SIZE_SECTION_0				(0x18)	/*Size of each phase output in a grid*/
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_PAF_SLICE_0_DEST_OFFSET_SECTION_0			(0x200)	/*FF register offset from kernel base*/
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_OUT_PAF_NEXT_SLICE_OFFSET_SECTION_0			(0x180)	/*Determines the next FF location*/

/* Sliced Parameter Terminal In does not exist for PAF*/

/* Sliced Parameter Terminal Out does not exist for PAF*/

#define IA_CSS_ISA_PROGRAM_TERMINAL_PAF_SECTION_COUNT							(0)
/* ==================== PAF specs - END ==================== */

/* ==================== LSC_SENSOR_TYPE_0 specs - START ==================== */
/* in addition to register bank, it has a 0xC00 memory bank to store LUT, found in reg_descr.hsd */

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_0_SECTION_COUNT				(0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_SECTION_COUNT			(1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_COMPUTE_UNITS_PER_ELEM		(2)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_PER_SLICE		(128)	/* HW limit for slice height calculation */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH	(8)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH	(64)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT	(8)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT	(64)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_MAX_SLICE_SIZE_SECTION_0		(0x400)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_ELEM_SIZE_SECTION_0			(0x4)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_SLICE_0_DEST_OFFSET_SECTION_0	(0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_0_NEXT_SLICE_OFFSET_SECTION_0		(0x400)

/* Spatial Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_0 */

/* Sliced Parameter Terminal In does not exist for LSC_SENSOR_TYPE_0 */

/* Sliced Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_0 */
/* ==================== LSC_SENSOR_TYPE_0 specs - END ==================== */

/* ==================== LSC_SENSOR_TYPE_1 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_1_SECTION_COUNT				(0)

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_SECTION_COUNT			(1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_COMPUTE_UNITS_PER_ELEM		(1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_PER_SLICE		(128)	/* HW limit for slice height calculation */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH	(8)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH	(64)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT	(8)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT	(64)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_MAX_SLICE_SIZE_SECTION_0		(0x400)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_ELEM_SIZE_SECTION_0			(0x8)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_SLICE_0_DEST_OFFSET_SECTION_0	(0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_1_NEXT_SLICE_OFFSET_SECTION_0		(0x400)

/* Spatial Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_1 */

/* Sliced Parameter Terminal In does not exist for LSC_SENSOR_TYPE_1 */

/* Sliced Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_1 */
/* ==================== LSC_SENSOR_TYPE_1 specs - END ==================== */

/* ==================== LSC_SENSOR_TYPE_2 specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LSC_SENSOR_TYPE_2_SECTION_COUNT				(0)

#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_SECTION_COUNT			(1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_COMPUTE_UNITS_PER_ELEM		(1)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_PER_SLICE		(32)	/* HW limit for slice height calculation */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_WIDTH	(8)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_WIDTH	(32)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MIN_COMPUTE_UNITS_FRAGMENT_HEIGHT	(8)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_COMPUTE_UNITS_FRAGMENT_HEIGHT	(32)	/* HW limit for checking only */
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_MAX_SLICE_SIZE_SECTION_0		(0x400)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_ELEM_SIZE_SECTION_0			(0x20)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_SLICE_0_DEST_OFFSET_SECTION_0	(0x0)
#define IA_CSS_ISA_SPATIAL_PARAMETER_TERMINAL_IN_LSC_SENSOR_TYPE_2_NEXT_SLICE_OFFSET_SECTION_0		(0x400)

/* Spatial Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_2 */

/* Sliced Parameter Terminal In does not exist for LSC_SENSOR_TYPE_2 */

/* Sliced Parameter Terminal Out does not exist for LSC_SENSOR_TYPE_2 */

/* ==================== LSC_SENSOR_TYPE_2 specs - END ==================== */

#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_SECTION_COUNT				IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_SECTION_COUNT
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_0			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_0
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_0			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_0
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_1			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_1
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_1			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_1
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_2			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_2
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_2			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_2
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_3			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_3
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_3			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_3
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_4			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_4
#define IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_4			IA_CSS_ISA_PARAMETER_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_4
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_IDS_SECTION_COUNT			IA_CSS_ISA_PARAMETER_TERMINAL_OUT_IDS_V3_1_SECTION_COUNT
#define IA_CSS_ISA_PROGRAM_TERMINAL_IDS_SECTION_COUNT				IA_CSS_ISA_PROGRAM_TERMINAL_IDS_V3_1_SECTION_COUNT
#define IA_CSS_ISA_PROGRAM_TERMINAL_IDS_MAX_SIZE_SECTION_0			IA_CSS_ISA_PROGRAM_TERMINAL_IDS_V3_1_MAX_SIZE_SECTION_0
#define IA_CSS_ISA_PROGRAM_TERMINAL_IDS_DEST_OFFSET_SECTION_0			IA_CSS_ISA_PROGRAM_TERMINAL_IDS_V3_1_DEST_OFFSET_SECTION_0

#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_SECTION_COUNT					IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_SECTION_COUNT
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_0				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_0
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_0				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_0
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_1				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_1
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_1				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_1
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_2				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_2
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_2				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_2
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_3				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_3
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_3				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_3
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_4				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_MAX_SIZE_SECTION_4
#define IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_4				IA_CSS_ISA_PARAMETER_TERMINAL_DPC_V3_DEST_OFFSET_SECTION_4

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_DPC_SECTION_COUNT				IA_CSS_ISA_PARAMETER_TERMINAL_OUT_DPC_V2_SECTION_COUNT
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_SECTION_COUNT			IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_SECTION_COUNT
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_MAX_SLICE_SIZE_SECTION_0		IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_SLICE_0_DEST_OFFSET_SECTION_0	IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_NEXT_SLICE_OFFSET_SECTION_0		IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_MAX_SLICE_SIZE_SECTION_1		IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_SLICE_0_DEST_OFFSET_SECTION_1	IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_NEXT_SLICE_OFFSET_SECTION_1		IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_V2_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_SECTION_COUNT			IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_SECTION_COUNT
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_MAX_SLICE_SIZE_SECTION_0		IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_SLICE_0_DEST_OFFSET_SECTION_0	IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_NEXT_SLICE_OFFSET_SECTION_0	IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_MAX_SLICE_SIZE_SECTION_1		IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_SLICE_0_DEST_OFFSET_SECTION_1	IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_NEXT_SLICE_OFFSET_SECTION_1	IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_V2_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_SECTION_COUNT					IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_SECTION_COUNT
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_0				IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_MAX_SIZE_SECTION_0
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_0				IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_0
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_1				IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_MAX_SIZE_SECTION_1
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_1				IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_1
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_2				IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_MAX_SIZE_SECTION_2
#define IA_CSS_ISA_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_2				IA_CSS_ISA_PROGRAM_TERMINAL_DPC_V2_DEST_OFFSET_SECTION_2

/* ==================== LCA specs -- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_SECTION_COUNT			(6)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_MAX_SIZE_SECTION_0	(0xc) /* 0x0 to 0xb */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_DEST_OFFSET_SECTION_0	(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_MAX_SIZE_SECTION_1	(0xcc) /* 0x10 to 0xdb */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_DEST_OFFSET_SECTION_1	(0x10)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_MAX_SIZE_SECTION_2	(0x510) /* 0x100 to 0x60f */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_DEST_OFFSET_SECTION_2	(0x100)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_MAX_SIZE_SECTION_3	(0x510) /* 0x6c0 to 0xbcf */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_DEST_OFFSET_SECTION_3	(0x6c0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_MAX_SIZE_SECTION_4	(0x510) /* 0xc80 to 0x118f */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_DEST_OFFSET_SECTION_4	(0xc80)
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_MAX_SIZE_SECTION_5	(0x510) /* 0x1240 to 0x174f */
#define IA_CSS_ISA_PARAMETER_TERMINAL_LCA_DEST_OFFSET_SECTION_5	(0x1240)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_LCA_SECTION_COUNT		(0)

#define IA_CSS_ISA_PROGRAM_TERMINAL_LCA_SECTION_COUNT			(1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_LCA_MAX_SIZE_SECTION_0		(4) /* 0x1800 to 0x1803*/
#define IA_CSS_ISA_PROGRAM_TERMINAL_LCA_DEST_OFFSET_SECTION_0	(0x1800)
/* ==================== LCA specs -- END ==================== */

/* ==================== WBA_WBA specs - START ==================== */
#define IA_CSS_PSA_PARAMETER_TERMINAL_B2B_WBA_SECTION_COUNT               (1)
#define IA_CSS_PSA_PARAMETER_TERMINAL_B2B_WBA_MAX_SIZE_SECTION_0          (0x20)
#define IA_CSS_PSA_PARAMETER_TERMINAL_B2B_WBA_DEST_OFFSET_SECTION_0       (0x0)
/* ==================== WBA_WBA specs - END ==================== */

/* leave those for now to pass isys compilation */
/* ==================== SIS_WB_SIS specs - START ==================== */
/* This device is similar to the WBA device in the PSA (with respect to registermap) */
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_WB_SIS_SECTION_COUNT            (2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_WB_SIS_MAX_SIZE_SECTION_0       (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_WB_SIS_DEST_OFFSET_SECTION_0    (0x1C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_WB_SIS_MAX_SIZE_SECTION_1       (0x1C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_WB_SIS_DEST_OFFSET_SECTION_1    (0x0)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_SIS_WB_SIS_SECTION_COUNT        (0)

/* Spatial Parameter Terminal In does not exist for SIS_WB_SIS */

/* Spatial Parameter Terminal Out does not exist for SIS_WB_SIS */

#define IA_CSS_ISA_PROGRAM_TERMINAL_SIS_WB_SIS_SECTION_COUNT              (0)
/* ==================== SIS_WB_SIS specs - END ==================== */

/* ==================== SIS_SIS specs - START ==================== */
/* TODO: The SIS device does not yet expose the functionality for cropping */
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_SIS_SECTION_COUNT               (1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_SIS_MAX_SIZE_SECTION_0          (0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_SIS_SIS_DEST_OFFSET_SECTION_0       (0x0)

#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_SIS_SIS_SECTION_COUNT           (0)

/* Spatial Parameter Terminal In does not exist for SIS_SIS */

/* Spatial Parameter Terminal Out does not exist for SIS_SIS */

#define IA_CSS_ISA_PROGRAM_TERMINAL_SIS_SIS_SECTION_COUNT                 (0)
/* ==================== SIS_SIS specs - END ==================== */

/* ==================== STREAM_CROP specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_STREAM_CROP_SECTION_COUNT		(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_STREAM_CROP_MAX_SIZE_SECTION_0	(0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_STREAM_CROP_DEST_OFFSET_SECTION_0	(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_STREAM_CROP_SECTION_COUNT	(0)

#define IA_CSS_ISA_PROGRAM_TERMINAL_STREAM_CROP_SECTION_COUNT		(1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_STREAM_CROP_MAX_SIZE_SECTION_0	(0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_STREAM_CROP_DEST_OFFSET_SECTION_0	(0x4)
/* ==================== STREAM_CROP specs - END ==================== */

/* ==================== BNR specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_SECTION_COUNT			(2)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_MAX_SIZE_SECTION_0	(0x2C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_DEST_OFFSET_SECTION_0	(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_MAX_SIZE_SECTION_1	(0xA4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_BNR_DEST_OFFSET_SECTION_1	(0x34)

#define IA_CSS_ISA_PROGRAM_TERMINAL_BNR_SECTION_COUNT			(1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BNR_MAX_SIZE_SECTION_0		(0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_BNR_DEST_OFFSET_SECTION_0	(0x2C)
/* ==================== BNR specs - END ==================== */

/* ==================== ISA_DM specs - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_ISA_DEMOSAIC_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_ISA_DEMOSAIC_MAX_SIZE_SECTION_0		(0x2C)
#define IA_CSS_ISA_PARAMETER_TERMINAL_ISA_DEMOSAIC_DEST_OFFSET_SECTION_0	(0x0)

/* ==================== ISA_DM specs - END ==================== */

/* ====================  specs PIFCONV_SIS_A- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SIS_A_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SIS_A_MAX_SIZE_SECTION_0		(0xc)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SIS_A_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_OUTPUT_SIS_A_SECTION_COUNT		(0)
/* ====================  specs PIFCONV_SIS_A- END ==================== */

/* ====================  specs PIFCONV_SIS_B- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SIS_B_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SIS_B_MAX_SIZE_SECTION_0		(0x12)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SIS_B_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_OUTPUT_SIS_B_SECTION_COUNT		(0)
/* ====================  specs PIFCONV_SIS_B- END ==================== */

/* ====================  specs PIFCONV_ISA_ORIG- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_ISA_ORIG_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_ISA_ORIG_MAX_SIZE_SECTION_0		(0xc)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_ISA_ORIG_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_OUTPUT_ISA_ORIG_SECTION_COUNT		(0)
/* ====================  specs PIFCONV_ISA_ORIG- END ==================== */

/* ====================  specs PIFCONV_ISA_SCALED_A- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SCALED_A_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SCALED_A_MAX_SIZE_SECTION_0		(0xc)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SCALED_A_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_OUTPUT_SCALED_A_SECTION_COUNT		(0)
/* ====================  specs PIFCONV_ISA_SCALED_A- END ==================== */

/* ====================  specs PIFCONV_ISA_SCALED_B- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SCALED_B_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SCALED_B_MAX_SIZE_SECTION_0		(0xc)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_SCALED_B_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_OUTPUT_SCALED_B_SECTION_COUNT		(0)
/* ====================  specs PIFCONV_ISA_SCALED_B- END ==================== */

/* ====================  specs PIFCONV_ISA_FULL- START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_ISA_FULL_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_ISA_FULL_MAX_SIZE_SECTION_0		(0xc)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_OUTPUT_ISA_FULL_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_OUTPUT_ISA_FULL_SECTION_COUNT		(0)
/* ====================  specs -PIFCONV_ISA_FULL_OUT END ==================== */

/* ====================  specs PIFCONV_ISA_IR_DEPTH - START ==================== */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_ISA_IR_DEPTH_OUTPUT_IR_DEPTH_SECTION_COUNT			(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_ISA_IR_DEPTH_OUTPUT_IR_DEPTH_MAX_SIZE_SECTION_0		(0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIFCONV_ISA_IR_DEPTH_OUTPUT_IR_DEPTH_DEST_OFFSET_SECTION_0		(0x0)
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIFCONV_ISA_IR_DEPTH_OUTPUT_IR_DEPTH_SECTION_COUNT		(0)

#define IA_CSS_ISA_PROGRAM_TERMINAL_PIFCONV_OUTPUT_ISA_IR_DEPTH_SECTION_COUNT			(2)
#define IA_CSS_ISA_PROGRAM_TERMINAL_PIFCONV_OUTPUT_ISA_IR_DEPTH_MAX_SIZE_SECTION_0		(0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_PIFCONV_OUTPUT_ISA_IR_DEPTH_DEST_OFFSET_SECTION_0		(0x4)
#define IA_CSS_ISA_PROGRAM_TERMINAL_PIFCONV_OUTPUT_ISA_IR_DEPTH_MAX_SIZE_SECTION_1		(0x4)
#define IA_CSS_ISA_PROGRAM_TERMINAL_PIFCONV_OUTPUT_ISA_IR_DEPTH_DEST_OFFSET_SECTION_1		(0x0) /* 0 because this register is in GPreg, NOT in Pifconv device. */
/* ====================  specs PIFCONV_ISA_IR_DEPTH - END ==================== */

/* ==================== PIXEL FORMATTER specs - START ==================== */
/* The base address of the Pixel Formatter device is 0x271000 */
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIXEL_FORMATTER_SECTION_COUNT		(1)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIXEL_FORMATTER_MAX_SIZE_SECTION_0	(0x4)
#define IA_CSS_ISA_PARAMETER_TERMINAL_PIXEL_FORMATTER_DEST_OFFSET_SECTION_0	(0x0) /* Base address of the Config register in the Pixel Formatter device: Taken from MAS */
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_PIXEL_FORMATTER_SECTION_COUNT		(0x0)

#define IA_CSS_ISA_PROGRAM_TERMINAL_PIXEL_FORMATTER_SECTION_COUNT		(1)
#define IA_CSS_ISA_PROGRAM_TERMINAL_PIXEL_FORMATTER_MAX_SIZE_SECTION_0		(0x8)
#define IA_CSS_ISA_PROGRAM_TERMINAL_PIXEL_FORMATTER_DEST_OFFSET_SECTION_0	(0x20) /* Base address of Start register in the Pixel Formatter device: Taken from MAS
											and base address of size register in the Pixel Formatter device is 0x24. */

/* TODO: REMOVE BACKWARD COMPATIBILITY */
/* NOT USED defs - needed for legacy*/
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AWB_SECTION_COUNT					IA_P2P_PARAM_IN_TERMINAL_FF_AWB_STATISTICS_SECTION_COUNT
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AWB_MAX_SIZE_SECTION_0			IA_P2P_PARAM_IN_TERMINAL_FF_AWB_STATISTICS_SECTION_0_SIZE
#define IA_CSS_ISA_PARAMETER_TERMINAL_3A_STAT_AWB_DEST_OFFSET_SECTION_0			IA_P2P_PARAM_IN_TERMINAL_FF_AWB_STATISTICS_DEST_OFFSET_SECTION_0
#define IA_CSS_ISA_PARAMETER_TERMINAL_OUT_3A_STAT_AWB_SECTION_COUNT				IA_P2P_PROGRAM_TERMINAL_FF_AWB_STATISTICS_SECTION_COUNT
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AWB_MAX_SIZE_SECTION_0				IA_P2P_PROGRAM_TERMINAL_FF_AWB_STATISTICS_SECTION_0_SIZE
#define IA_CSS_ISA_PROGRAM_TERMINAL_3A_STAT_AWB_SECTION_COUNT					IA_P2P_PROGRAM_TERMINAL_FF_AWB_STATISTICS_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_IDS_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_2 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_2
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_2 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_2
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_3 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_3
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_3 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_3
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_4 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_MAX_SIZE_SECTION_4
#define IA_CSS_ISYS_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_4 IA_CSS_ISA_PARAMETER_TERMINAL_IDS_DEST_OFFSET_SECTION_4
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_IDS_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_IDS_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_IDS_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_IDS_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_IDS_MAX_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_IDS_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_IDS_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_IDS_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_DPC_SECTION_COUNT
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_2 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_2
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_2 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_2
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_3 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_MAX_SIZE_SECTION_3
#define IA_CSS_ISYS_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_3 IA_CSS_ISA_PARAMETER_TERMINAL_DPC_DEST_OFFSET_SECTION_3
#define IA_CSS_ISYS_PARAMETER_TERMINAL_OUT_DPC_SECTION_COUNT IA_CSS_ISA_PARAMETER_TERMINAL_OUT_DPC_SECTION_COUNT
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_SECTION_COUNT IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_SECTION_COUNT
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_IN_DPC_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_IN_DPC_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_SECTION_COUNT IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_SECTION_COUNT
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_MAX_SLICE_SIZE_SECTION_0 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_MAX_SLICE_SIZE_SECTION_0
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_SLICE_0_DEST_OFFSET_SECTION_0 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_SLICE_0_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_NEXT_SLICE_OFFSET_SECTION_0 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_NEXT_SLICE_OFFSET_SECTION_0
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_MAX_SLICE_SIZE_SECTION_1 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_MAX_SLICE_SIZE_SECTION_1
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_SLICE_0_DEST_OFFSET_SECTION_1 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_SLICE_0_DEST_OFFSET_SECTION_1
#define IA_CSS_ISYS_SLICED_PARAMETER_TERMINAL_OUT_DPC_NEXT_SLICE_OFFSET_SECTION_1 IA_CSS_ISA_SLICED_PARAMETER_TERMINAL_OUT_DPC_NEXT_SLICE_OFFSET_SECTION_1
#define IA_CSS_ISYS_PROGRAM_TERMINAL_DPC_SECTION_COUNT IA_CSS_ISA_PROGRAM_TERMINAL_DPC_SECTION_COUNT
#define IA_CSS_ISYS_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_0 IA_CSS_ISA_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_0
#define IA_CSS_ISYS_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_1 IA_CSS_ISA_PROGRAM_TERMINAL_DPC_MAX_SIZE_SECTION_1
#define IA_CSS_ISYS_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_1 IA_CSS_ISA_PROGRAM_TERMINAL_DPC_DEST_OFFSET_SECTION_1
/* END OF TODO */

#endif /* __IA_CSS_ISA_PARAMETER_DEFS_DEP_H */
